<?php
/* --------------------------------------------------------------
   AddedDataToCache.php 2020-04-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Cache\Events;

use Gambio\Core\Cache\CachedData;
use Gambio\Core\Cache\Exceptions\InvalidArgumentException;

/**
 * Class AddedDataToCache
 *
 * @package Gambio\Core\Cache\Events
 */
class AddedDataToCache
{
    /**
     * @var string
     */
    private $namespace;
    
    /**
     * @var CachedData
     */
    private $cachedData;
    
    
    /**
     * AddedDataToCache constructor.
     *
     * @param string     $namespace
     * @param CachedData $cachedData
     */
    private function __construct(string $namespace, CachedData $cachedData)
    {
        $this->namespace  = $namespace;
        $this->cachedData = $cachedData;
    }
    
    
    /**
     * @param string     $namespace
     * @param CachedData $cachedData
     *
     * @return AddedDataToCache
     */
    public static function create(string $namespace, CachedData $cachedData): AddedDataToCache
    {
        if (strlen($namespace) > 64 || preg_match('/^[A-Za-z0-9_\.]+$/', $namespace) !== 1) {
            throw InvalidArgumentException::forNamespace();
        }
        
        return new self($namespace, $cachedData);
    }
    
    
    /**
     * @return string
     */
    public function namespace(): string
    {
        return $this->namespace;
    }
    
    
    /**
     * @return CachedData
     */
    public function cachedData(): CachedData
    {
        return $this->cachedData;
    }
}